* Title: 	table9.do
* Version: 	23 May 2018
* Purpose: 	Create table of time use for jobless prime-age men


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/tables/log/table9, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use dta/atus_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)


*******************************************************************************
* (2) Create table of time use
*******************************************************************************

* Group 1: Employed, Coastal States
gen group1 = (UnempB==0 & RegionI == 0)

* Group 2: Employed, Eastern Heartland
gen group2 = (UnempB==0 & RegionI == 1)

* Group 3: Employed, Western Heartland
gen group3 = (UnempB==0 & RegionI == 2)

* Group 4: Not Employed, Coastal States
gen group4 = (UnempB==1 & RegionI == 0)

* Group 5: Not Employed, Eastern Heartland
gen group5 = (UnempB==1 & RegionI == 1)

* Group 6: Not Employed, Western Heartland
gen group6 = (UnempB==1 & RegionI == 2)

egen test = rowtotal(group1 group2 group3 group4 group5 group6)
assert test==1
drop test

forval i = 1/6 {
	foreach var of varlist T_PersonalCare-T_ComputerUse {
		assert !mi(`var')
		gen `var'`i' = `var' if (group`i' == 1)
	}
	
	gen Obs`i' = PrimeMaleD if (group`i' == 1)
}

collapse 	(rawsum)	Obs* ///
			(mean)		T_*1 T_*2 T_*3 T_*4 T_*5 T_*6 ///
			[pw = wt06]

forval i = 1/6 {

	ren T_PersonalCare`i' 	Group`i'a_PersonalCare
	ren T_HouseholdAct`i'	Group`i'b_HouseholdAct
	ren T_Food`i'			Group`i'c_Food
	ren T_CareOthers`i'		Group`i'd_CareOthers
	ren T_TotalWork`i'		Group`i'e_TotalWork
	ren T_LookingWork`i'	Group`i'f_LookingWork
	ren T_Education`i'		Group`i'g_Education
	ren T_TotalLeisure`i'	Group`i'h_TotalLeisure
	ren T_Socializing`i'	Group`i'i_Socializing
	ren T_TV`i'				Group`i'j_TV
	ren T_ComputerUse`i'	Group`i'k_ComputerUse
	
	ren Obs`i'				Group`i'l_obs
}
gen Total=1
reshape long Group1 Group2 Group3 Group4 Group5 Group6, i(Total) j(category) str
drop Total

replace category = "Personal care" 			if category == "a_PersonalCare"
replace category = "Household activities"	if category == "b_HouseholdAct"
replace category = "Food" 					if category == "c_Food"
replace category = "Caring for others" 		if category == "d_CareOthers"
replace category = "Total work" 			if category == "e_TotalWork"
replace category = "Search for work" 		if category == "f_LookingWork"
replace category = "Education" 				if category == "g_Education"
replace category = "Total leisure" 			if category == "h_TotalLeisure"
replace category = "Socializing" 			if category == "i_Socializing"
replace category = "TV" 					if category == "j_TV"
replace category = "Computer use" 			if category == "k_ComputerUse"
replace category = "Observations" 			if category == "l_obs"


ren Group1 Employed_Coastal
ren Group2 Employed_Eastern_Heartland
ren Group3 Employed_Western_Heartland
ren Group4 NotEmployed_Coastal
ren Group5 NotEmployed_Eastern_Heartland
ren Group6 NotEmployed_Western_Heartland

* Save dataset
save output/tables/dta/table9.dta, replace


*******************************************************************************
* (3) End of file
*******************************************************************************

log close
exit, clear
